<?php
/**
 * The template to display Admin notices
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0.64
 */

$takeout_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$takeout_skins_args = get_query_var( 'takeout_skins_notice_args' );
?>
<div class="takeout_admin_notice takeout_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$takeout_theme_img = takeout_get_file_url( 'screenshot.jpg' );
	if ( '' != $takeout_theme_img ) {
		?>
		<div class="takeout_notice_image"><img src="<?php echo esc_url( $takeout_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'takeout' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="takeout_notice_title">
		<?php esc_html_e( 'New skins are available', 'takeout' ); ?>
	</h3>
	<?php

	// Description
	$takeout_total      = $takeout_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$takeout_skins_msg  = $takeout_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $takeout_total, 'takeout' ), $takeout_total ) . '</strong>'
							: '';
	$takeout_total      = $takeout_skins_args['free'];
	$takeout_skins_msg .= $takeout_total > 0
							? ( ! empty( $takeout_skins_msg ) ? ' ' . esc_html__( 'and', 'takeout' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $takeout_total, 'takeout' ), $takeout_total ) . '</strong>'
							: '';
	$takeout_total      = $takeout_skins_args['pay'];
	$takeout_skins_msg .= $takeout_skins_args['pay'] > 0
							? ( ! empty( $takeout_skins_msg ) ? ' ' . esc_html__( 'and', 'takeout' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $takeout_total, 'takeout' ), $takeout_total ) . '</strong>'
							: '';
	?>
	<div class="takeout_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'takeout' ), $takeout_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="takeout_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $takeout_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'takeout' );
			?>
		</a>
	</div>
</div>
