<?php
/**
 * The style "light" of the Team
 *
 * @package ThemeREX Addons
 * @since v1.4.3
 */

$args = get_query_var('trx_addons_args_sc_team');

$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);
$link = empty($args['no_links']) ? get_permalink() : '';

$sportspress_player_number = '';
if ( takeout_exists_sportspress() ) {
	if (!is_array($meta)) { $meta = array(); }
	$sportspress_meta_item = takeout_sportspress_meta_item($args);
	if(!empty($sportspress_meta_item['subtitle'])) {
		$meta['subtitle'] = $sportspress_meta_item['subtitle'];
	}
	$sportspress_player_number = $sportspress_meta_item['number'];
}

if ($args['slider']) {
	?><div class="slider-slide swiper-slide"><?php
} else if ($args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'], !empty($args['columns_tablet']) ? $args['columns_tablet'] : '', !empty($args['columns_mobile']) ? $args['columns_mobile'] : '')); ?>"><?php
}

$thumbnail = (has_post_thumbnail() ? ' has_post_thumbnail ' : ' no_post_thumbnail ');
?>
<div data-post-id="<?php the_ID(); ?>" <?php
	post_class( 'sc_team_item sc_item_container post_container' . (empty($post_link) ? ' no_links' : ''). $thumbnail );
	trx_addons_add_blog_animation('team', $args);
?>>
	<?php
	if(!has_post_thumbnail()) { ?>
		<h4 class="sc_team_item_title entry-title"><?php
			if (!empty($link)) {
				?><a href="<?php echo esc_url($link); ?>"><?php
			}
			the_title();
			if (!empty($link)) {
				?></a><?php
			}
		?></h4>
	<?php }

	// Featured image
	trx_addons_get_template_part('templates/tpl.featured.php',
								'trx_addons_args_featured',
								apply_filters( 'trx_addons_filter_args_featured', array(
											'allow_theme_replace' => false,
											'no_links' => empty($link),
											'class' => 'sc_team_item_thumb',
											'hover' => 'info_anim',
											'thumb_bg' => true,
											'thumb_size' => takeout_get_thumb_size('full'),
											'post_info' => apply_filters('trx_addons_filter_post_info',
													'<div class="trx_addons_hover_team">'
															. '<h4 class="sc_team_item_title entry-title trx_addons_hover_title">'
																. (!empty($link) ? '<a href="' . esc_url($link) . '">' : '')
																	. get_the_title()
																. (!empty($link) ? '</a>' : '')
															. '</h4>'
															. (!empty($meta['subtitle']) ? ('<div class="sc_team_item_subtitle trx_addons_hover_title">'
																. esc_html($meta['subtitle']) . '</div>') 
																	: (!empty($meta['position']) ? ('<div class="sc_team_item_subtitle trx_addons_hover_title">'
																		. esc_html($meta['position'])
																		. '</div>') 
																	: '')
																)
													. '</div>'
																. ($sportspress_player_number)
																. '<a class="post_link sc_team_item_link" href="' . esc_url( $link ) . '"></a>'
																. (!empty($meta["socials"][0]["name"]) ? '<div class="sc_team_item_socials socials_wrap trx_addons_hover_info">' . trim(trx_addons_get_socials_links_custom($meta['socials'])) . '</div>' : ''),
															'team-info-light', $args )
											), 'team-light', $args )
								);
	?>
</div>
<?php
if ($args['slider'] || $args['columns'] > 1) {
	?></div><?php
}
?>