<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

// Page (category, tag, archive, author) title

if ( takeout_need_page_title() ) {
	takeout_sc_layouts_showed( 'title', true );
	takeout_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								takeout_show_post_meta(
									apply_filters(
										'takeout_filter_post_meta_args', array(
											'components' => join( ',', takeout_array_get_keys_by_value( takeout_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', takeout_array_get_keys_by_value( takeout_get_theme_option( 'counters' ) ) ),
											'seo'        => takeout_is_on( takeout_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$takeout_blog_title           = takeout_get_blog_title();
							$takeout_blog_title_text      = '';
							$takeout_blog_title_class     = '';
							$takeout_blog_title_link      = '';
							$takeout_blog_title_link_text = '';
							if ( is_array( $takeout_blog_title ) ) {
								$takeout_blog_title_text      = $takeout_blog_title['text'];
								$takeout_blog_title_class     = ! empty( $takeout_blog_title['class'] ) ? ' ' . $takeout_blog_title['class'] : '';
								$takeout_blog_title_link      = ! empty( $takeout_blog_title['link'] ) ? $takeout_blog_title['link'] : '';
								$takeout_blog_title_link_text = ! empty( $takeout_blog_title['link_text'] ) ? $takeout_blog_title['link_text'] : '';
							} else {
								$takeout_blog_title_text = $takeout_blog_title;
							}
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr( $takeout_blog_title_class ); ?>"<?php
								if ( takeout_is_on( takeout_get_theme_option( 'seo_snippets' ) ) ) {
									?> itemprop="headline"<?php
								}
							?>>
								<?php
								$takeout_top_icon = takeout_get_term_image_small();
								if ( ! empty( $takeout_top_icon ) ) {
									$takeout_attr = takeout_getimagesize( $takeout_top_icon );
									?>
									<img src="<?php echo esc_url( $takeout_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'takeout' ); ?>"
										<?php
										if ( ! empty( $takeout_attr[3] ) ) {
											takeout_show_layout( $takeout_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $takeout_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $takeout_blog_title_link ) && ! empty( $takeout_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $takeout_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $takeout_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'takeout_action_breadcrumbs' );
						$takeout_breadcrumbs = ob_get_contents();
						ob_end_clean();
						takeout_show_layout( $takeout_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
