<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

$takeout_args = get_query_var( 'takeout_logo_args' );

// Site logo
$takeout_logo_type   = isset( $takeout_args['type'] ) ? $takeout_args['type'] : '';
$takeout_logo_image  = takeout_get_logo_image( $takeout_logo_type );
$takeout_logo_text   = takeout_is_on( takeout_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$takeout_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $takeout_logo_image['logo'] ) || ! empty( $takeout_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $takeout_logo_image['logo'] ) ) {
			if ( empty( $takeout_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($takeout_logo_image['logo']) && (int) $takeout_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$takeout_attr = takeout_getimagesize( $takeout_logo_image['logo'] );
				echo '<img src="' . esc_url( $takeout_logo_image['logo'] ) . '"'
						. ( ! empty( $takeout_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $takeout_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $takeout_logo_text ) . '"'
						. ( ! empty( $takeout_attr[3] ) ? ' ' . wp_kses_data( $takeout_attr[3] ) : '' )
						. '>';
			}
		} else {
			takeout_show_layout( takeout_prepare_macros( $takeout_logo_text ), '<span class="logo_text">', '</span>' );
			takeout_show_layout( takeout_prepare_macros( $takeout_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
