<?php
/**
 * The template to display default site header
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

$takeout_header_css   = '';
$takeout_header_image = get_header_image();
$takeout_header_video = takeout_get_header_video();
if ( ! empty( $takeout_header_image ) && takeout_trx_addons_featured_image_override( is_singular() || takeout_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$takeout_header_image = takeout_get_current_mode_image( $takeout_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $takeout_header_image ) || ! empty( $takeout_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $takeout_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $takeout_header_image ) {
		echo ' ' . esc_attr( takeout_add_inline_css_class( 'background-image: url(' . esc_url( $takeout_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( takeout_is_on( takeout_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight takeout-full-height';
	}
	$takeout_header_scheme = takeout_get_theme_option( 'header_scheme' );
	if ( ! empty( $takeout_header_scheme ) && ! takeout_is_inherit( $takeout_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $takeout_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $takeout_header_video ) ) {
		get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( takeout_is_on( takeout_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
