<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0.06
 */

$takeout_header_css   = '';
$takeout_header_image = get_header_image();
$takeout_header_video = takeout_get_header_video();
if ( ! empty( $takeout_header_image ) && takeout_trx_addons_featured_image_override( is_singular() || takeout_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$takeout_header_image = takeout_get_current_mode_image( $takeout_header_image );
}

$takeout_header_id = takeout_get_custom_header_id();
$takeout_header_meta = get_post_meta( $takeout_header_id, 'trx_addons_options', true );
if ( ! empty( $takeout_header_meta['margin'] ) ) {
	takeout_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( takeout_prepare_css_value( $takeout_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $takeout_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $takeout_header_id ) ) ); ?>
				<?php
				echo ! empty( $takeout_header_image ) || ! empty( $takeout_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $takeout_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $takeout_header_image ) {
					echo ' ' . esc_attr( takeout_add_inline_css_class( 'background-image: url(' . esc_url( $takeout_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( takeout_is_on( takeout_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight takeout-full-height';
				}
				$takeout_header_scheme = takeout_get_theme_option( 'header_scheme' );
				if ( ! empty( $takeout_header_scheme ) && ! takeout_is_inherit( $takeout_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $takeout_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $takeout_header_video ) ) {
		get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'takeout_action_show_layout', $takeout_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
