<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0.10
 */

// Footer sidebar
$takeout_footer_name    = takeout_get_theme_option( 'footer_widgets' );
$takeout_footer_present = ! takeout_is_off( $takeout_footer_name ) && is_active_sidebar( $takeout_footer_name );
if ( $takeout_footer_present ) {
	takeout_storage_set( 'current_sidebar', 'footer' );
	$takeout_footer_wide = takeout_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $takeout_footer_name ) ) {
		dynamic_sidebar( $takeout_footer_name );
	}
	$takeout_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $takeout_out ) ) {
		$takeout_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $takeout_out );
		$takeout_need_columns = true;   //or check: strpos($takeout_out, 'columns_wrap')===false;
		if ( $takeout_need_columns ) {
			$takeout_columns = max( 0, (int) takeout_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $takeout_columns ) {
				$takeout_columns = min( 4, max( 1, takeout_tags_count( $takeout_out, 'aside' ) ) );
			}
			if ( $takeout_columns > 1 ) {
				$takeout_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $takeout_columns ) . ' widget', $takeout_out );
			} else {
				$takeout_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $takeout_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'takeout_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $takeout_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $takeout_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'takeout_action_before_sidebar', 'footer' );
				takeout_show_layout( $takeout_out );
				do_action( 'takeout_action_after_sidebar', 'footer' );
				if ( $takeout_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $takeout_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'takeout_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
