<?php
/**
 * The template to display the site logo in the footer
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0.10
 */

// Logo
if ( takeout_is_on( takeout_get_theme_option( 'logo_in_footer' ) ) ) {
	$takeout_logo_image = takeout_get_logo_image( 'footer' );
	$takeout_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $takeout_logo_image['logo'] ) || ! empty( $takeout_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $takeout_logo_image['logo'] ) ) {
					$takeout_attr = takeout_getimagesize( $takeout_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $takeout_logo_image['logo'] ) . '"'
								. ( ! empty( $takeout_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $takeout_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'takeout' ) . '"'
								. ( ! empty( $takeout_attr[3] ) ? ' ' . wp_kses_data( $takeout_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $takeout_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $takeout_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
