<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

$takeout_template_args = get_query_var( 'takeout_template_args' );
$takeout_columns = 1;
if ( is_array( $takeout_template_args ) ) {
	$takeout_columns    = empty( $takeout_template_args['columns'] ) ? 1 : max( 1, $takeout_template_args['columns'] );
	$takeout_blog_style = array( $takeout_template_args['type'], $takeout_columns );
	if ( ! empty( $takeout_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $takeout_columns > 1 ) {
	    $takeout_columns_class = takeout_get_column_class( 1, $takeout_columns, ! empty( $takeout_template_args['columns_tablet']) ? $takeout_template_args['columns_tablet'] : '', ! empty($takeout_template_args['columns_mobile']) ? $takeout_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $takeout_columns_class ); ?>">
		<?php
	}
} else {
	$takeout_template_args = array();
}
$takeout_expanded    = ! takeout_sidebar_present() && takeout_get_theme_option( 'expand_content' ) == 'expand';
$takeout_post_format = get_post_format();
$takeout_post_format = empty( $takeout_post_format ) ? 'standard' : str_replace( 'post-format-', '', $takeout_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $takeout_post_format ) );
	takeout_add_blog_animation( $takeout_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$takeout_hover      = ! empty( $takeout_template_args['hover'] ) && ! takeout_is_inherit( $takeout_template_args['hover'] )
							? $takeout_template_args['hover']
							: takeout_get_theme_option( 'image_hover' );
	$takeout_components = ! empty( $takeout_template_args['meta_parts'] )
							? ( is_array( $takeout_template_args['meta_parts'] )
								? $takeout_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $takeout_template_args['meta_parts'] ) )
								)
							: takeout_array_get_keys_by_value( takeout_get_theme_option( 'meta_parts' ) );
	takeout_show_post_featured( apply_filters( 'takeout_filter_args_featured',
		array(
			'no_links'   => ! empty( $takeout_template_args['no_links'] ),
			'hover'      => $takeout_hover,
			'meta_parts' => $takeout_components,
			'thumb_size' => ! empty( $takeout_template_args['thumb_size'] )
							? $takeout_template_args['thumb_size']
							: takeout_get_thumb_size( strpos( takeout_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $takeout_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$takeout_template_args
	) );

	// Title and post meta
	$takeout_show_title = get_the_title() != '';
	$takeout_show_meta  = count( $takeout_components ) > 0 && ! in_array( $takeout_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $takeout_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'takeout_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'takeout_action_before_post_title' );
				if ( empty( $takeout_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'takeout_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'takeout_filter_show_blog_excerpt', empty( $takeout_template_args['hide_excerpt'] ) && takeout_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'takeout_filter_show_blog_meta', $takeout_show_meta, $takeout_components, 'excerpt' ) ) {
				if ( count( $takeout_components ) > 0 ) {
					do_action( 'takeout_action_before_post_meta' );
					takeout_show_post_meta(
						apply_filters(
							'takeout_filter_post_meta_args', array(
								'components' => join( ',', $takeout_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'takeout_action_after_post_meta' );
				}
			}

			if ( takeout_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'takeout_action_before_full_post_content' );
					the_content( '' );
					do_action( 'takeout_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'takeout' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'takeout' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				takeout_show_post_content( $takeout_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'takeout_filter_show_blog_readmore',  ! isset( $takeout_template_args['more_button'] ) || ! empty( $takeout_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $takeout_template_args['no_links'] ) ) {
					do_action( 'takeout_action_before_post_readmore' );
					if ( takeout_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						takeout_show_post_more_link( $takeout_template_args, '<p>', '</p>' );
					} else {
						takeout_show_post_comments_link( $takeout_template_args, '<p>', '</p>' );
					}
					do_action( 'takeout_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $takeout_template_args ) ) {
	if ( ! empty( $takeout_template_args['slider'] ) || $takeout_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
