<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

$takeout_template_args = get_query_var( 'takeout_template_args' );

if ( is_array( $takeout_template_args ) ) {
	$takeout_columns    = empty( $takeout_template_args['columns'] ) ? 2 : max( 1, $takeout_template_args['columns'] );
	$takeout_blog_style = array( $takeout_template_args['type'], $takeout_columns );
    $takeout_columns_class = takeout_get_column_class( 1, $takeout_columns, ! empty( $takeout_template_args['columns_tablet']) ? $takeout_template_args['columns_tablet'] : '', ! empty($takeout_template_args['columns_mobile']) ? $takeout_template_args['columns_mobile'] : '' );
} else {
	$takeout_template_args = array();
	$takeout_blog_style = explode( '_', takeout_get_theme_option( 'blog_style' ) );
	$takeout_columns    = empty( $takeout_blog_style[1] ) ? 2 : max( 1, $takeout_blog_style[1] );
    $takeout_columns_class = takeout_get_column_class( 1, $takeout_columns );
}
$takeout_expanded   = ! takeout_sidebar_present() && takeout_get_theme_option( 'expand_content' ) == 'expand';

$takeout_post_format = get_post_format();
$takeout_post_format = empty( $takeout_post_format ) ? 'standard' : str_replace( 'post-format-', '', $takeout_post_format );

?><div class="<?php
	if ( ! empty( $takeout_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( takeout_is_blog_style_use_masonry( $takeout_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $takeout_columns ) : esc_attr( $takeout_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $takeout_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $takeout_columns )
				. ' post_layout_' . esc_attr( $takeout_blog_style[0] )
				. ' post_layout_' . esc_attr( $takeout_blog_style[0] ) . '_' . esc_attr( $takeout_columns )
	);
	takeout_add_blog_animation( $takeout_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$takeout_hover      = ! empty( $takeout_template_args['hover'] ) && ! takeout_is_inherit( $takeout_template_args['hover'] )
							? $takeout_template_args['hover']
							: takeout_get_theme_option( 'image_hover' );

	$takeout_components = ! empty( $takeout_template_args['meta_parts'] )
							? ( is_array( $takeout_template_args['meta_parts'] )
								? $takeout_template_args['meta_parts']
								: explode( ',', $takeout_template_args['meta_parts'] )
								)
							: takeout_array_get_keys_by_value( takeout_get_theme_option( 'meta_parts' ) );

	takeout_show_post_featured( apply_filters( 'takeout_filter_args_featured',
		array(
			'thumb_size' => ! empty( $takeout_template_args['thumb_size'] )
				? $takeout_template_args['thumb_size']
				: takeout_get_thumb_size(
					'classic' == $takeout_blog_style[0]
						? ( strpos( takeout_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $takeout_columns > 2 ? 'big' : 'huge' )
								: ( $takeout_columns > 2
									? ( $takeout_expanded ? 'square' : 'square' )
									: ($takeout_columns > 1 ? 'square' : ( $takeout_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( takeout_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $takeout_columns > 2 ? 'masonry-big' : 'full' )
								: ($takeout_columns === 1 ? ( $takeout_expanded ? 'huge' : 'big' ) : ( $takeout_columns <= 2 && $takeout_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $takeout_hover,
			'meta_parts' => $takeout_components,
			'no_links'   => ! empty( $takeout_template_args['no_links'] ),
        ),
        'content-classic',
        $takeout_template_args
    ) );

	// Title and post meta
	$takeout_show_title = get_the_title() != '';
	$takeout_show_meta  = count( $takeout_components ) > 0 && ! in_array( $takeout_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $takeout_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'takeout_filter_show_blog_meta', $takeout_show_meta, $takeout_components, 'classic' ) ) {
				if ( count( $takeout_components ) > 0 ) {
					do_action( 'takeout_action_before_post_meta' );
					takeout_show_post_meta(
						apply_filters(
							'takeout_filter_post_meta_args', array(
							'components' => join( ',', $takeout_components ),
							'seo'        => false,
							'echo'       => true,
						), $takeout_blog_style[0], $takeout_columns
						)
					);
					do_action( 'takeout_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'takeout_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'takeout_action_before_post_title' );
				if ( empty( $takeout_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'takeout_action_after_post_title' );
			}

			if( !in_array( $takeout_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'takeout_filter_show_blog_readmore', ! $takeout_show_title || ! empty( $takeout_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $takeout_template_args['no_links'] ) ) {
						do_action( 'takeout_action_before_post_readmore' );
						takeout_show_post_more_link( $takeout_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'takeout_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $takeout_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('takeout_filter_show_blog_excerpt', empty($takeout_template_args['hide_excerpt']) && takeout_get_theme_option('excerpt_length') > 0, 'classic')) {
			takeout_show_post_content($takeout_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $takeout_template_args['more_button'] )) {
			if ( empty( $takeout_template_args['no_links'] ) ) {
				do_action( 'takeout_action_before_post_readmore' );
				takeout_show_post_more_link( $takeout_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'takeout_action_after_post_readmore' );
			}
		}
		$takeout_content = ob_get_contents();
		ob_end_clean();
		takeout_show_layout($takeout_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
