<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.71.0
 */

$takeout_template_args = get_query_var( 'takeout_template_args' );
if ( ! is_array( $takeout_template_args ) ) {
	$takeout_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$takeout_columns       = 1;

$takeout_expanded      = ! takeout_sidebar_present() && takeout_get_theme_option( 'expand_content' ) == 'expand';

$takeout_post_format   = get_post_format();
$takeout_post_format   = empty( $takeout_post_format ) ? 'standard' : str_replace( 'post-format-', '', $takeout_post_format );

if ( is_array( $takeout_template_args ) ) {
	$takeout_columns    = empty( $takeout_template_args['columns'] ) ? 1 : max( 1, $takeout_template_args['columns'] );
	$takeout_blog_style = array( $takeout_template_args['type'], $takeout_columns );
	if ( ! empty( $takeout_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $takeout_columns > 1 ) {
	    $takeout_columns_class = takeout_get_column_class( 1, $takeout_columns, ! empty( $takeout_template_args['columns_tablet']) ? $takeout_template_args['columns_tablet'] : '', ! empty($takeout_template_args['columns_mobile']) ? $takeout_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $takeout_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $takeout_post_format ) );
	takeout_add_blog_animation( $takeout_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$takeout_hover      = ! empty( $takeout_template_args['hover'] ) && ! takeout_is_inherit( $takeout_template_args['hover'] )
							? $takeout_template_args['hover']
							: takeout_get_theme_option( 'image_hover' );
	$takeout_components = ! empty( $takeout_template_args['meta_parts'] )
							? ( is_array( $takeout_template_args['meta_parts'] )
								? $takeout_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $takeout_template_args['meta_parts'] ) )
								)
							: takeout_array_get_keys_by_value( takeout_get_theme_option( 'meta_parts' ) );
	takeout_show_post_featured( apply_filters( 'takeout_filter_args_featured',
		array(
			'no_links'   => ! empty( $takeout_template_args['no_links'] ),
			'hover'      => $takeout_hover,
			'meta_parts' => $takeout_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $takeout_template_args['thumb_size'] )
								? $takeout_template_args['thumb_size']
								: takeout_get_thumb_size( 
								in_array( $takeout_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( takeout_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $takeout_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$takeout_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$takeout_show_title = get_the_title() != '';
		$takeout_show_meta  = count( $takeout_components ) > 0 && ! in_array( $takeout_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $takeout_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'takeout_filter_show_blog_categories', $takeout_show_meta && in_array( 'categories', $takeout_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'takeout_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						takeout_show_post_meta( apply_filters(
															'takeout_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $takeout_hover, 1
															)
											);
						?>
					</div>
					<?php
					$takeout_components = takeout_array_delete_by_value( $takeout_components, 'categories' );
					do_action( 'takeout_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'takeout_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'takeout_action_before_post_title' );
					if ( empty( $takeout_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'takeout_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $takeout_template_args['excerpt_length'] ) && ! in_array( $takeout_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$takeout_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'takeout_filter_show_blog_excerpt', empty( $takeout_template_args['hide_excerpt'] ) && takeout_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				takeout_show_post_content( $takeout_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'takeout_filter_show_blog_meta', $takeout_show_meta, $takeout_components, 'band' ) ) {
			if ( count( $takeout_components ) > 0 ) {
				do_action( 'takeout_action_before_post_meta' );
				takeout_show_post_meta(
					apply_filters(
						'takeout_filter_post_meta_args', array(
							'components' => join( ',', $takeout_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'takeout_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'takeout_filter_show_blog_readmore', ! $takeout_show_title || ! empty( $takeout_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $takeout_template_args['no_links'] ) ) {
				do_action( 'takeout_action_before_post_readmore' );
				takeout_show_post_more_link( $takeout_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'takeout_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $takeout_template_args ) ) {
	if ( ! empty( $takeout_template_args['slider'] ) || $takeout_columns > 1 ) {
		?>
		</div>
		<?php
	}
}