<?php
/**
 * The template to display Admin notices
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0.1
 */

$takeout_theme_slug = get_option( 'template' );
$takeout_theme_obj  = wp_get_theme( $takeout_theme_slug );
?>
<div class="takeout_admin_notice takeout_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$takeout_theme_img = takeout_get_file_url( 'screenshot.jpg' );
	if ( '' != $takeout_theme_img ) {
		?>
		<div class="takeout_notice_image"><img src="<?php echo esc_url( $takeout_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'takeout' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="takeout_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'takeout' ),
				$takeout_theme_obj->get( 'Name' ) . ( TAKEOUT_THEME_FREE ? ' ' . __( 'Free', 'takeout' ) : '' ),
				$takeout_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="takeout_notice_text">
		<p class="takeout_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $takeout_theme_obj->description ) );
			?>
		</p>
		<p class="takeout_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'takeout' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="takeout_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=takeout_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'takeout' );
			?>
		</a>
	</div>
</div>
