<?php
/* SportsPress support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
if ( ! function_exists( 'takeout_sportspress_theme_setup1' ) ) {
	add_action( 'after_setup_theme', 'takeout_sportspress_theme_setup1', 1 );
	function takeout_sportspress_theme_setup1() {
		if ( takeout_exists_sportspress() ) {
			add_filter( 'takeout_filter_list_sidebars', 'takeout_sportspress_list_sidebars' );
		}
	}
}

// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'takeout_sportspress_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'takeout_sportspress_theme_setup3', 3 );
	function takeout_sportspress_theme_setup3() {
		if ( takeout_exists_sportspress() ) {
			// Section 'SportsPress'
			takeout_storage_merge_array(
				'options', '', array_merge(
					array(
						'sportspress' => array(
							'title' => esc_html__( 'SportsPress', 'takeout' ),
							'desc'  => wp_kses_data( __( 'Select parameters to display the SportsPress pages', 'takeout' ) ),
							'icon'  => 'icon-sport',
							'type'  => 'section',
						),
					),
					takeout_options_get_list_cpt_options( 'sportspress', esc_html__( 'SportsPress', 'takeout' ) )
				)
			);

			takeout_storage_set_array_after( 'options', 'sportspress_single',
				array(
					'show_related_posts_single_sportspress'            => array(
						'std'      => 0,
						'type'     => 'hidden',
					),
					'show_post_meta_single_sportspress'                => array(
						'std'   => 0,
						'type'  => 'hidden',
					),
					'posts_navigation_single_sportspress'           => array(
						'std'     => 'none',
						'type'    => 'hidden',
					),
					'show_author_info_single_sportspress'           => array(
						'std'     => 0,
						'type'    => 'hidden',
					),
				)
			);
		}
	}
}

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('takeout_sportspress_theme_setup9')) {
	add_action( 'after_setup_theme', 'takeout_sportspress_theme_setup9', 9 );
	function takeout_sportspress_theme_setup9() {
		add_theme_support( 'sportspress' );
		if(takeout_exists_sportspress()){
			add_filter( 'takeout_filter_detect_blog_mode', 'takeout_sportspress_detect_blog_mode' );
		}
		if (is_admin()) {			
			add_filter( 'takeout_filter_tgmpa_required_plugins',		'takeout_sportspress_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'takeout_sportspress_tgmpa_required_plugins' ) ) {
	function takeout_sportspress_tgmpa_required_plugins($list=array()) {
		if (takeout_storage_isset('required_plugins', 'sportspress') && takeout_storage_get_array( 'required_plugins', 'sportspress', 'install' ) !== false) {
			$list[] = array(
				'name'     => takeout_storage_get_array( 'required_plugins', 'sportspress', 'title' ),
				'slug'     => 'sportspress',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'takeout_exists_sportspress' ) ) {
	function takeout_exists_sportspress() {
		return class_exists('SportsPress');
	}
}


// Enqueue sportspress styles for frontend
if ( ! function_exists( 'takeout_sportspress_frontend_scripts' ) ) {
    add_action( 'wp_enqueue_scripts', 'takeout_sportspress_frontend_scripts', 1150 );
    function takeout_sportspress_frontend_scripts() {
        if ( takeout_is_on( takeout_get_theme_option( 'debug_mode' ) ) ) {
            $takeout_url = takeout_get_file_url( 'plugins/sportspress/sportspress.css' );
            if ( '' != $takeout_url ) {
                wp_enqueue_style( 'takeout-sportspress', $takeout_url, array(), null );
            }
        }
    }
}

// Merge sportspress styles
if ( ! function_exists( 'takeout_sportspress_merge_styles' ) ) {
    add_filter( 'takeout_filter_merge_styles', 'takeout_sportspress_merge_styles');
    function takeout_sportspress_merge_styles( $list ) {
        $list[ 'plugins/sportspress/sportspress.css' ] = true;
        return $list;
    }
}

// Enqueue sportspress responsive styles for frontend
if ( ! function_exists( 'takeout_sportspress_responsive_styles' ) ) {
	add_action( 'wp_enqueue_scripts', 'takeout_sportspress_responsive_styles', 2050 );
	function takeout_sportspress_responsive_styles() {
		if ( takeout_is_on( takeout_get_theme_option( 'debug_mode' ) ) ) {
			$takeout_url_qw_extension = takeout_get_file_url( 'plugins/sportspress/sportspress-responsive.css' );
            if ( '' != $takeout_url_qw_extension ) {
                wp_enqueue_style( 'takeout-sportspress-responsive', $takeout_url_qw_extension, array(), null, takeout_media_for_load_css_responsive( 'takeout-sportspress-responsive' ) );
            }
		}
	}
}

// Merge sportspress responsive styles
if ( ! function_exists( 'takeout_sportspress_merge_styles_responsive' ) ) {
	add_filter('takeout_filter_merge_styles_responsive', 'takeout_sportspress_merge_styles_responsive', 20);
	function takeout_sportspress_merge_styles_responsive( $list ) {
		$list[] = 'plugins/sportspress/sportspress-responsive.css';
		return $list;
	}
}

// Add plugin-specific fonts to the custom CSS
if ( takeout_exists_sportspress() ) {
	require_once takeout_get_file_dir( 'plugins/sportspress/sportspress-style.php' );
}


// Register size
add_action( 'init', 'takeout_register_size_sportspress' );
function takeout_register_size_sportspress() {
    // Reassigning the size of the cutting images of the plugin "SportsPress" - sportspress - prefix of the plugin itself
    add_image_size( 'sportspress-fit-medium', 500, 500, false );
    add_image_size( 'sportspress-fit-icon',  400, 400, false );
    add_image_size( 'sportspress-crop-medium',  400, 400, true );
    //add_image_size( 'sportspress-fit-mini',  32, 32, false );
}


// Return true, if current page is any sportpress page
if ( !function_exists( 'takeout_is_sportspress_page' ) ) {
	function takeout_is_sportspress_page() {
		$rez = false;
		if ( takeout_exists_sportspress() && ! is_search() ) {
			$rez = is_sportspress() || is_tax( sp_taxonomies() );
		}
		return $rez;
	}
}

// Detect current blog mode
if ( ! function_exists( 'takeout_sportspress_detect_blog_mode' ) ) {
	//Handler of the add_filter( 'takeout_filter_detect_blog_mode', 'takeout_sportspress_detect_blog_mode' );
	function takeout_sportspress_detect_blog_mode( $mode = '' ) {
		if ( takeout_is_sportspress_page() ) {
			$mode = 'sportspress';
		}
		return $mode;
	}
}


// Meta item
if ( ! function_exists( 'takeout_sportspress_meta_item' ) ) {
	function takeout_sportspress_meta_item( $args = array() ) {
		if( takeout_exists_sportspress() ) {
			$meta = array('subtitle' => '', 'number' => '');
			$sportspress_subtitle = '';
			$sportspress_subtitle = array();
			$sportspress_player_number = '';
			if (isset($args['taxonomy']) && ($args['taxonomy'] == 'sp_league' || $args['taxonomy'] == 'sp_season')) {				
				if ($args['post_type'] == 'sp_staff') {
					$staff = new SP_Staff(get_the_id());
					$roles = $staff->roles();
					if (is_array($roles) && !empty($roles)) {
						foreach ($roles as $k) {
							$sportspress_subtitle[] = $k->name;
						}
						$sportspress_subtitle = implode(", ", $sportspress_subtitle);
					}
				} else if ($args['post_type'] == 'sp_player') {
					$player = new SP_Player(get_the_id());
					$positions = $player->positions();
					$number = get_post_meta( get_the_id(), 'sp_number' );
					if(is_array($number) && !empty($number)) {
						$sportspress_player_number .= '<span class="sp-player-number">' . $number[0] . '</span>';
					}
					if (is_array($positions) && !empty($positions)) {
						foreach ($positions as $k) {
							$sportspress_subtitle[] = $k->name;
						}
						$sportspress_subtitle = implode(", ", $sportspress_subtitle);
					}
				}
				$meta['subtitle'] = $sportspress_subtitle;
				$meta['number'] = $sportspress_player_number;
			}
			return $meta;
		}
	}
}


// Add sidebar
if ( ! function_exists( 'takeout_sportspress_list_sidebars' ) ) {
	//Handler of the add_filter( 'takeout_filter_list_sidebars', 'takeout_sportspress_list_sidebars' );
	function takeout_sportspress_list_sidebars( $list = array() ) {
		$list['sportspress_widgets'] = array(
			'name'        => esc_html__( 'SportsPress Widgets', 'takeout' ),
			'description' => esc_html__( 'Widgets to be shown on the SportsPress pages', 'takeout' ),
		);
		return $list;
	}
}


// Sportspress Custom Colors
if ( ! function_exists( 'takeout_sportspress_scripts' ) ) {
	function takeout_sportspress_scripts() {
		add_action( 'wp_print_scripts', 'takeout_sportspress_custom_colors', 30 );
	}
}
add_action( 'wp_enqueue_scripts', 'takeout_sportspress_scripts' );


if ( ! function_exists( 'takeout_sportspress_custom_colors' ) ) {
	function takeout_sportspress_custom_colors() {

		$colors = (array) get_option( 'themeboy', array() );
		$colors = array_map( 'esc_attr', $colors );
		
		// Return if colors not customized
		if ( ! isset( $colors['customize'] ) ) {
			$enabled = get_option( 'sportspress_enable_frontend_css', 'no' );
			if ( 'yes' !== $enabled ) return;
		} elseif ( ! $colors['customize'] ) {
			return;
		}

		// Defaults
		if ( empty( $colors['primary'] ) ) $colors['primary'] = '#2b353e';
		if ( empty( $colors['background'] ) ) $colors['background'] = '#f4f4f4';
		if ( empty( $colors['text'] ) ) $colors['text'] = '#222222';
		if ( empty( $colors['heading'] ) ) $colors['heading'] = '#ffffff';
		if ( empty( $colors['link'] ) ) $colors['link'] = '#00a69c';

		// Calculate colors
		$colors['primary_highlight'] = takeout_sportspress_hex_lighter( $colors['primary'], 30, true );
		$colors['highlight'] = takeout_sportspress_hex_lighter( $colors['background'], 30, true );
		$colors['border'] = takeout_sportspress_hex_darker( $colors['background'], 20, true );
		$colors['link_dark'] = takeout_sportspress_hex_darker( $colors['link'], 30, true );
		$colors['link_hover'] = takeout_sportspress_hex_darker( $colors['link'], 30, true );
		?>
		<style type="text/css"> /* Sportspress Custom Colors */
		table.sp-data-table,
		.sp-template-countdown .event-name,
		.sp-template-countdown .event-venue,
		.sp-template-countdown .event-league,
		.sp-template-countdown .event-date,
		.sp-template-details dl,
		.sp-template-photo {
			background: <?php echo esc_attr($colors['background']); ?>;
		}
		.sp-table-wrapper .dataTables_paginate,
		table.sp-data-table tfoot, table.sp-data-table thead {
			background: <?php echo esc_attr($colors['primary_highlight']); ?>;
		}
		table.sp-data-table tbody tr td.sp-highlight, table.sp-data-table tbody tr.highlighted td,
		.sp-highlight,
		.sp-template-event-calendar #today {
			background: <?php echo esc_attr($colors['highlight']); ?>;
		}
		.sp-heading,
		.sp-table-caption,
		.sp-template-gallery .gallery-caption,
		.sp-template-event-logos .sp-team-result,
		.sp-statistic-bar,
		.sp-tab-menu a {
			background: <?php echo esc_attr($colors['primary']); ?>;
		}
		table.sp-data-table, table.sp-data-table th, table.sp-data-table td,
		.sp-table-wrapper .dataTables_paginate,
		.sp-template-countdown .event-name,
		.sp-template-countdown .event-venue,
		.sp-template-countdown .event-league,
		.sp-template-countdown .event-date,
		.sp-template-details dt {
			border-color: <?php echo esc_attr($colors['border']); ?>;
		}
		.sp-template-countdown,
		.sp-template-countdown .event-name a,
		.sp-template-countdown h5,
		.sp-template-countdown .sp-countdown-wrapper h5.event-venue:not(.event-date),
		.sp-template-countdown .sp-countdown-wrapper h5.event-league,
		table.sp-data-table,
		.sp-view-all-link,
		.sp-template,
		.sp-template-details dl,
		.sp-tab-menu a,
		.sp-template-event-blocks .sp-event-venue {
			color: <?php echo esc_attr($colors['text']); ?>;
		}

		table.sp-data-table tfoot, table.sp-data-table thead,
		.sp-template .gallery-caption,
		.sp-template .gallery-caption a,
		.sp-heading,
		.sp-heading:hover,
		.sp-heading a:hover,
		.sp-table-caption,
		.sp-template-event-logos .sp-team-result,
		.single-sp_player .entry-header .entry-title strong,
		.sp-template-details dt,
		.sp-template-event-calendar #prev a,
		.sp-template-event-calendar #next a,
		.sp-table-wrapper .dataTables_paginate a,
		.sp-table-wrapper .dataTables_paginate,
		.sp-template-event-blocks table.sp-data-table,
		.sidebar .widget .sp-template-event-calendar thead th {
			color: <?php echo esc_attr($colors['heading']); ?>;
		}
		.sp-table-wrapper .dataTables_paginate a.current,
		.sp-table-wrapper .dataTables_paginate a.current:hover,
		.sp-template-countdown .event-name a:hover,
		.sp-view-all-link:hover,
		.sp-template-event-calendar #prev a:hover,
		.sp-template-event-calendar #next a:hover,
		.sp-template-event-blocks .sp-event-date a:hover,
		.single-sp_staff .entry-header .entry-title strong,
		.sp-message,
		.sp-template a,
		.sidebar .widget_sportspress a,
		.sidebar .widget .sp-template-event-calendar td#prev a,
		.sidebar .widget .sp-template-event-calendar td#next a,
		.sp-tab-menu .sp-tab-menu-item-active a, .sp-tab-menu .sp-tab-menu-item a:hover {
			color: <?php echo esc_attr($colors['link']); ?>;
		}
		.sp-template-player-gallery .gallery-item strong,
		.single-sp_player .entry-header .entry-title strong,
		.sp-statistic-bar-fill,
		.sidebar .widget .sp-template-event-calendar tbody td a:after,
		.sidebar .widget .sp-template-event-calendar td#today:before {
			background: <?php echo esc_attr($colors['link']); ?>;
		}
		.sp-message {
			border-color: <?php echo esc_attr($colors['link']); ?>;
		}
		.sp-table-caption {
			border-top-color: <?php echo esc_attr($colors['link']); ?>;
		}
		.sidebar .widget .sp-template-event-calendar td#prev a:hover,
		.sidebar .widget .sp-template-event-calendar td#next a:hover,
		.sidebar .widget_sportspress a:hover,
		.sp-table-wrapper .dataTables_paginate a:hover,
		table.sp-data-table th a:hover,
		.sp-template a:hover {
			color: <?php echo esc_attr($colors['link_hover']); ?>;
		}

		<?php do_action( 'sportspress_frontend_css', $colors ); ?>

		</style>
		<?php
	}
}


if ( ! function_exists( 'takeout_sportspress_rgb_from_hex' ) ) {
	function takeout_sportspress_rgb_from_hex( $color ) {
		$color = str_replace( '#', '', $color );
		// Convert shorthand colors to full format, e.g. "FFF" -> "FFFFFF"
		$color = preg_replace( '~^(.)(.)(.)$~', '$1$1$2$2$3$3', $color );

		$rgb['r'] = hexdec( $color[0].$color[1] );
		$rgb['g'] = hexdec( $color[2].$color[3] );
		$rgb['b'] = hexdec( $color[4].$color[5] );
		return $rgb;
	}
}

if ( ! function_exists( 'takeout_sportspress_hex_darker' ) ) {
	function takeout_sportspress_hex_darker( $color, $factor = 30, $absolute = false ) {
		$base = takeout_sportspress_rgb_from_hex( $color );
		$color = '#';

		foreach ($base as $k => $v) :
	    	if ( $absolute ) {
	    		$amount = $factor;
	    	} else {
		        $amount = $v / 100;
		        $amount = round($amount * $factor);
		    }
	        $new_decimal = max( $v - $amount, 0 );

	        $new_hex_component = dechex($new_decimal);
	        if(strlen($new_hex_component) < 2) :
	        	$new_hex_component = "0" . $new_hex_component;
	        endif;
	        $color .= $new_hex_component;
		endforeach;

		return $color;
	}
}

if ( ! function_exists( 'takeout_sportspress_hex_lighter' ) ) {
	function takeout_sportspress_hex_lighter( $color, $factor = 30, $absolute = false ) {
		$base = takeout_sportspress_rgb_from_hex( $color );
		$color = '#';

	    foreach ($base as $k => $v) :
	    	if ( $absolute ) {
	    		$amount = $factor;
	    	} else {
		        $amount = 255 - $v;
		        $amount = $amount / 100;
		        $amount = round($amount * $factor);
		    }
	        $new_decimal = min( $v + $amount, 255 );

	        $new_hex_component = dechex($new_decimal);
	        if(strlen($new_hex_component) < 2) :
	        	$new_hex_component = "0" . $new_hex_component;
	        endif;
	        $color .= $new_hex_component;
	   	endforeach;

	   	return $color;
	}
}




// One-click import support
//------------------------------------------------------------------------
/*
// Check plugin in the required plugins
if ( !function_exists( 'takeout_sportspress_importer_required_plugins' ) ) {
    if (is_admin()) add_filter( 'trx_addons_filter_importer_required_plugins',	'takeout_sportspress_importer_required_plugins', 10, 2 );
    function takeout_sportspress_importer_required_plugins($not_installed='', $list='') {
        if (strpos($list, 'sportspress')!==false && !takeout_exists_sportspress() )
            $not_installed .= '<br>' . esc_html__('SportsPress', 'takeout');
        return $not_installed;
    }
}

// Prevent import plugin's specific options if plugin is not installed
if ( !function_exists( 'takeout_sportspress_importer_check_options' ) ) {
	add_filter( 'trx_addons_filter_import_theme_options', 'takeout_sportspress_importer_check_options', 10, 4 );
	function takeout_sportspress_importer_check_options($allow, $k, $v, $options) {
		if ($allow && (strpos($k, 'sportspress_')===0) ) {
			$allow = takeout_exists_sportspress() && in_array('sportspress', $options['required_plugins']);
		}
		return $allow;
	}
}

// Add checkbox to the one-click importer
if ( !function_exists( 'takeout_sportspress_importer_show_params' ) ) {
	add_action( 'trx_addons_action_importer_params',	'takeout_sportspress_importer_show_params', 10, 1 );
	function takeout_sportspress_importer_show_params($importer) {
		if ( takeout_exists_sportspress() && in_array('sportspress', $importer->options['required_plugins']) ) {
			$importer->show_importer_params(array(
				'slug' => 'sportspress',
				'title' => esc_html__('Import SportsPress', 'takeout'),
				'part' => 0
			));
		}
	}
}

// Set plugin's specific importer options
if ( !function_exists( 'takeout_woocommerce_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options',	'takeout_woocommerce_importer_set_options' );
	function takeout_woocommerce_importer_set_options($options=array()) {
		if ( takeout_exists_sportspress() && in_array('sportspress', $options['required_plugins']) ) {
			$options['additional_options'][]	= 'sportspress_%';
			if (is_array($options['files']) && count($options['files']) > 0) {
				foreach ($options['files'] as $k => $v) {
					$options['files'][$k]['file_with_sportspress'] = str_replace('name.ext', 'sportspress.txt', $v['file_with_']);
				}
			}
		}
		return $options;
	}
}

// Display import progress
if ( !function_exists( 'takeout_sportspress_importer_import_fields' ) ) {
	add_action( 'trx_addons_action_importer_import_fields',	'takeout_sportspress_importer_import_fields', 10, 1 );
	function takeout_sportspress_importer_import_fields($importer) {
		if ( takeout_exists_sportspress() && in_array('sportspress', $importer->options['required_plugins']) ) {
			$importer->show_importer_fields(array(
					'slug'=>'sportspress',
					'title' => esc_html__('SportsPress meta', 'takeout')
				)
			);
		}
	}
}

// Export posts
if ( !function_exists( 'takeout_sportspress_importer_export' ) ) {
	add_action( 'trx_addons_action_importer_export',	'takeout_sportspress_importer_export', 10, 1 );
	function takeout_sportspress_importer_export($importer) {
		if ( takeout_exists_sportspress() && in_array('sportspress', $importer->options['required_plugins']) ) {
			trx_addons_fpc($importer->export_file_dir('sportspress.txt'), serialize( array(
					"sportspress_activities"						=> $importer->export_dump("sportspress_activities"),
					"sportspress_agents"							=> $importer->export_dump("sportspress_agents "),
					"sportspress_agents_services"					=> $importer->export_dump("sportspress_agents_services"),
					"sportspress_agent_meta"						=> $importer->export_dump("sportspress_agent_meta"),
					"sportspress_bookings"						=> $importer->export_dump("sportspress_bookings"),
					"sportspress_booking_intents"					=> $importer->export_dump("sportspress_booking_intents"),
					"sportspress_booking_meta"					=> $importer->export_dump("sportspress_booking_meta"),
					"sportspress_customers"						=> $importer->export_dump("sportspress_customers"),
					"sportspress_customer_meta"					=> $importer->export_dump("sportspress_customer_meta"),
					"sportspress_custom_prices"					=> $importer->export_dump("sportspress_custom_prices"),
					"sportspress_locations"						=> $importer->export_dump("sportspress_locations"),
					"sportspress_location_categories"				=> $importer->export_dump("sportspress_location_categories"),
					"sportspress_processes"						=> $importer->export_dump("sportspress_processes"),
					"sportspress_process_jobs"					=> $importer->export_dump("sportspress_process_jobs"),
					"sportspress_sent_reminders"					=> $importer->export_dump("sportspress_sent_reminders"),
					"sportspress_services"						=> $importer->export_dump("sportspress_services"),
					"sportspress_service_categories"				=> $importer->export_dump("sportspress_service_categories"),
					"sportspress_service_meta"					=> $importer->export_dump("sportspress_service_meta"),
					"sportspress_sessions"						=> $importer->export_dump("sportspress_sessions"),
					"sportspress_settings"						=> $importer->export_dump("sportspress_settings"),
					"sportspress_step_setting"					=> $importer->export_dump("sportspress_step_settings"),
					"sportspress_transactions"					=> $importer->export_dump("sportspress_transactions"),
					"sportspress_work_periods"					=> $importer->export_dump("sportspress_work_periods"),
				) )
			);
		}
	}
}

// Display exported data in the fields
if ( !function_exists( 'takeout_sportspress_importer_export_fields' ) ) {
	add_action( 'trx_addons_action_importer_export_fields',	'takeout_sportspress_importer_export_fields', 10, 1 );
	function takeout_sportspress_importer_export_fields($importer) {
		if ( takeout_exists_sportspress() && in_array('sportspress', $importer->options['required_plugins']) ) {
			$importer->show_exporter_fields(array(
					'slug'	=> 'sportspress',
					'title' => esc_html__('SportsPress', 'takeout')
				)
			);
		}
	}
}

// Import posts
if ( !function_exists( 'takeout_sportspress_importer_import' ) ) {
	add_action( 'trx_addons_action_importer_import', 'takeout_sportspress_importer_import', 10, 2 );
	function takeout_sportspress_importer_import($importer, $action) {
		if ( takeout_exists_sportspress() && in_array('sportspress', $importer->options['required_plugins']) ) {
			if ( $action == 'import_sportspress' ) {
				$importer->response['start_from_id'] = 0;
				$importer->import_dump('sportspress', esc_html__('SportsPress meta', 'takeout'));
			}
		}
	}
}
*/
?>