<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'takeout_sportspress_get_css' ) ) {
	add_filter( 'takeout_filter_get_css', 'takeout_sportspress_get_css', 10, 2 );
	function takeout_sportspress_get_css( $css, $args ) {
		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS

		.sp-template-details dt,
		.sp-template-gallery dd,
		.sp-table-wrapper .dataTables_paginate,
		.sp-data-table tfoot,
		.sp-event-calendar,
		.sp-template-countdown,
		.sc_team .post_featured .sp-player-number,
		.sp-template-event-logos .sp-event-logos,
		.sp-template-event-logos-block .sp-team-name {
			{$fonts['h5_font-family']}
		}
		.sp-template-countdown .event-venue:not(.event-date), .sp-template-countdown .event-league {
			{$fonts['p_font-family']}
		}
		.sp-view-all-link a {
			{$fonts['button_font-family']}
			{$fonts['button_font-size']}
			{$fonts['button_font-weight']}
			{$fonts['button_font-style']}
			{$fonts['button_line-height']}
			{$fonts['button_text-decoration']}
			{$fonts['button_text-transform']}
			{$fonts['button_letter-spacing']}
		}

CSS;
		}

		return $css;
	}
}