<?php
/**
 * The template to display single post
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

// Full post loading
$full_post_loading          = takeout_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = takeout_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = takeout_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$takeout_related_position   = takeout_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$takeout_posts_navigation   = takeout_get_theme_option( 'posts_navigation' );
$takeout_prev_post          = false;
$takeout_prev_post_same_cat = (int)takeout_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( takeout_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	takeout_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'takeout_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $takeout_posts_navigation ) {
		$takeout_prev_post = get_previous_post( $takeout_prev_post_same_cat );  // Get post from same category
		if ( ! $takeout_prev_post && $takeout_prev_post_same_cat ) {
			$takeout_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $takeout_prev_post ) {
			$takeout_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $takeout_prev_post ) ) {
		takeout_sc_layouts_showed( 'featured', false );
		takeout_sc_layouts_showed( 'title', false );
		takeout_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $takeout_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/content', 'single-' . takeout_get_theme_option( 'single_style' ) ), 'single-' . takeout_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $takeout_related_position, 'inside' ) === 0 ) {
		$takeout_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'takeout_action_related_posts' );
		$takeout_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $takeout_related_content ) ) {
			$takeout_related_position_inside = max( 0, min( 9, takeout_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $takeout_related_position_inside ) {
				$takeout_related_position_inside = mt_rand( 1, 9 );
			}

			$takeout_p_number         = 0;
			$takeout_related_inserted = false;
			$takeout_in_block         = false;
			$takeout_content_start    = strpos( $takeout_content, '<div class="post_content' );
			$takeout_content_end      = strrpos( $takeout_content, '</div>' );

			for ( $i = max( 0, $takeout_content_start ); $i < min( strlen( $takeout_content ) - 3, $takeout_content_end ); $i++ ) {
				if ( $takeout_content[ $i ] != '<' ) {
					continue;
				}
				if ( $takeout_in_block ) {
					if ( strtolower( substr( $takeout_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$takeout_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $takeout_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $takeout_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$takeout_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $takeout_content[ $i + 1 ] && in_array( $takeout_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$takeout_p_number++;
					if ( $takeout_related_position_inside == $takeout_p_number ) {
						$takeout_related_inserted = true;
						$takeout_content = ( $i > 0 ? substr( $takeout_content, 0, $i ) : '' )
											. $takeout_related_content
											. substr( $takeout_content, $i );
					}
				}
			}
			if ( ! $takeout_related_inserted ) {
				if ( $takeout_content_end > 0 ) {
					$takeout_content = substr( $takeout_content, 0, $takeout_content_end ) . $takeout_related_content . substr( $takeout_content, $takeout_content_end );
				} else {
					$takeout_content .= $takeout_related_content;
				}
			}
		}

		takeout_show_layout( $takeout_content );
	}

	// Comments
	do_action( 'takeout_action_before_comments' );
	comments_template();
	do_action( 'takeout_action_after_comments' );

	// Related posts
	if ( 'below_content' == $takeout_related_position
		&& ( 'scroll' != $takeout_posts_navigation || (int)takeout_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)takeout_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'takeout_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $takeout_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $takeout_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $takeout_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $takeout_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'takeout_action_nav_links_single_scroll_data', $takeout_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
