<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

if ( takeout_sidebar_present() ) {
	
	$takeout_sidebar_type = takeout_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $takeout_sidebar_type && ! takeout_is_layouts_available() ) {
		$takeout_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $takeout_sidebar_type ) {
		// Default sidebar with widgets
		$takeout_sidebar_name = takeout_get_theme_option( 'sidebar_widgets' );
		takeout_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $takeout_sidebar_name ) ) {
			dynamic_sidebar( $takeout_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$takeout_sidebar_id = takeout_get_custom_sidebar_id();
		do_action( 'takeout_action_show_layout', $takeout_sidebar_id );
	}
	$takeout_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $takeout_out ) ) {
		$takeout_sidebar_position    = takeout_get_theme_option( 'sidebar_position' );
		$takeout_sidebar_position_ss = takeout_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $takeout_sidebar_position );
			echo ' sidebar_' . esc_attr( $takeout_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $takeout_sidebar_type );

			$takeout_sidebar_scheme = apply_filters( 'takeout_filter_sidebar_scheme', takeout_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $takeout_sidebar_scheme ) && ! takeout_is_inherit( $takeout_sidebar_scheme ) && 'custom' != $takeout_sidebar_type ) {
				echo ' scheme_' . esc_attr( $takeout_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="takeout_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'takeout_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $takeout_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$takeout_title = apply_filters( 'takeout_filter_sidebar_control_title', 'float' == $takeout_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'takeout' ) : '' );
				$takeout_text  = apply_filters( 'takeout_filter_sidebar_control_text', 'above' == $takeout_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'takeout' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $takeout_title ); ?>"><?php echo esc_html( $takeout_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'takeout_action_before_sidebar', 'sidebar' );
				takeout_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $takeout_out ) );
				do_action( 'takeout_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'takeout_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
