<?php
/**
 * The Header: Logo and main menu
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( takeout_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'takeout_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'takeout_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('takeout_action_body_wrap_attributes'); ?>>

		<?php do_action( 'takeout_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'takeout_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('takeout_action_page_wrap_attributes'); ?>>

			<?php do_action( 'takeout_action_page_wrap_start' ); ?>

			<?php
			$takeout_full_post_loading = ( takeout_is_singular( 'post' ) || takeout_is_singular( 'attachment' ) ) && takeout_get_value_gp( 'action' ) == 'full_post_loading';
			$takeout_prev_post_loading = ( takeout_is_singular( 'post' ) || takeout_is_singular( 'attachment' ) ) && takeout_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $takeout_full_post_loading && ! $takeout_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="takeout_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'takeout_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'takeout' ); ?></a>
				<?php if ( takeout_sidebar_present() ) { ?>
				<a class="takeout_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'takeout_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'takeout' ); ?></a>
				<?php } ?>
				<a class="takeout_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'takeout_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'takeout' ); ?></a>

				<?php
				do_action( 'takeout_action_before_header' );

				// Header
				$takeout_header_type = takeout_get_theme_option( 'header_type' );
				if ( 'custom' == $takeout_header_type && ! takeout_is_layouts_available() ) {
					$takeout_header_type = 'default';
				}
				get_template_part( apply_filters( 'takeout_filter_get_template_part', "templates/header-" . sanitize_file_name( $takeout_header_type ) ) );

				// Side menu
				if ( in_array( takeout_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'takeout_filter_use_navi_mobile', true ) ) {
					get_template_part( apply_filters( 'takeout_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'takeout_action_after_header' );

			}
			?>

			<?php do_action( 'takeout_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( takeout_is_off( takeout_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $takeout_header_type ) ) {
						$takeout_header_type = takeout_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $takeout_header_type && takeout_is_layouts_available() ) {
						$takeout_header_id = takeout_get_custom_header_id();
						if ( $takeout_header_id > 0 ) {
							$takeout_header_meta = takeout_get_custom_layout_meta( $takeout_header_id );
							if ( ! empty( $takeout_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$takeout_footer_type = takeout_get_theme_option( 'footer_type' );
					if ( 'custom' == $takeout_footer_type && takeout_is_layouts_available() ) {
						$takeout_footer_id = takeout_get_custom_footer_id();
						if ( $takeout_footer_id ) {
							$takeout_footer_meta = takeout_get_custom_layout_meta( $takeout_footer_id );
							if ( ! empty( $takeout_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'takeout_action_page_content_wrap_class', $takeout_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'takeout_filter_is_prev_post_loading', $takeout_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( takeout_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'takeout_action_page_content_wrap_data', $takeout_prev_post_loading );
			?>>
				<?php
				do_action( 'takeout_action_page_content_wrap', $takeout_full_post_loading || $takeout_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'takeout_filter_single_post_header', takeout_is_singular( 'post' ) || takeout_is_singular( 'attachment' ) ) ) {
					if ( $takeout_prev_post_loading ) {
						if ( takeout_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'takeout_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$takeout_path = apply_filters( 'takeout_filter_get_template_part', 'templates/single-styles/' . takeout_get_theme_option( 'single_style' ) );
					if ( takeout_get_file_dir( $takeout_path . '.php' ) != '' ) {
						get_template_part( $takeout_path );
					}
				}

				// Widgets area above page
				$takeout_body_style   = takeout_get_theme_option( 'body_style' );
				$takeout_widgets_name = takeout_get_theme_option( 'widgets_above_page', 'hide' );
				$takeout_show_widgets = ! takeout_is_off( $takeout_widgets_name ) && is_active_sidebar( $takeout_widgets_name );
				if ( $takeout_show_widgets ) {
					if ( 'fullscreen' != $takeout_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					takeout_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $takeout_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'takeout_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $takeout_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'takeout_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'takeout_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="takeout_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( takeout_is_singular( 'post' ) || takeout_is_singular( 'attachment' ) )
							&& $takeout_prev_post_loading 
							&& takeout_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'takeout_action_between_posts' );
						}

						// Widgets area above content
						takeout_create_widgets_area( 'widgets_above_content' );

						do_action( 'takeout_action_page_content_start_text' );
