<?php
$takeout_woocommerce_sc = takeout_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $takeout_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$takeout_scheme = takeout_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $takeout_scheme ) && ! takeout_is_inherit( $takeout_scheme ) ) {
			echo ' scheme_' . esc_attr( $takeout_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( takeout_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( takeout_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$takeout_css      = '';
			$takeout_bg_image = takeout_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $takeout_bg_image ) ) {
				$takeout_css .= 'background-image: url(' . esc_url( takeout_get_attachment_url( $takeout_bg_image ) ) . ');';
			}
			if ( ! empty( $takeout_css ) ) {
				echo ' style="' . esc_attr( $takeout_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$takeout_anchor_icon = takeout_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$takeout_anchor_text = takeout_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $takeout_anchor_icon ) || ! empty( $takeout_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $takeout_anchor_icon ) ? ' icon="' . esc_attr( $takeout_anchor_icon ) . '"' : '' )
											. ( ! empty( $takeout_anchor_text ) ? ' title="' . esc_attr( $takeout_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( takeout_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' takeout-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$takeout_css      = '';
				$takeout_bg_mask  = takeout_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$takeout_bg_color_type = takeout_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $takeout_bg_color_type ) {
					$takeout_bg_color = takeout_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $takeout_bg_color_type ) {
					$takeout_bg_color = takeout_get_scheme_color( 'bg_color', $takeout_scheme );
				} else {
					$takeout_bg_color = '';
				}
				if ( ! empty( $takeout_bg_color ) && $takeout_bg_mask > 0 ) {
					$takeout_css .= 'background-color: ' . esc_attr(
						1 == $takeout_bg_mask ? $takeout_bg_color : takeout_hex2rgba( $takeout_bg_color, $takeout_bg_mask )
					) . ';';
				}
				if ( ! empty( $takeout_css ) ) {
					echo ' style="' . esc_attr( $takeout_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$takeout_caption     = takeout_get_theme_option( 'front_page_woocommerce_caption' );
				$takeout_description = takeout_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $takeout_caption ) || ! empty( $takeout_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $takeout_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $takeout_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $takeout_caption, 'takeout_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $takeout_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $takeout_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $takeout_description ), 'takeout_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $takeout_woocommerce_sc ) {
						$takeout_woocommerce_sc_ids      = takeout_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$takeout_woocommerce_sc_per_page = count( explode( ',', $takeout_woocommerce_sc_ids ) );
					} else {
						$takeout_woocommerce_sc_per_page = max( 1, (int) takeout_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$takeout_woocommerce_sc_columns = max( 1, min( $takeout_woocommerce_sc_per_page, (int) takeout_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$takeout_woocommerce_sc}"
										. ( 'products' == $takeout_woocommerce_sc
												? ' ids="' . esc_attr( $takeout_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $takeout_woocommerce_sc
												? ' category="' . esc_attr( takeout_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $takeout_woocommerce_sc
												? ' orderby="' . esc_attr( takeout_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( takeout_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $takeout_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $takeout_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
