<?php
$takeout_slider_sc = takeout_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $takeout_slider_sc ) && strpos( $takeout_slider_sc, '[' ) !== false && strpos( $takeout_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( takeout_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$takeout_anchor_icon = takeout_get_theme_option( 'front_page_title_anchor_icon' );
		$takeout_anchor_text = takeout_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $takeout_anchor_icon ) || ! empty( $takeout_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $takeout_anchor_icon ) ? ' icon="' . esc_attr( $takeout_anchor_icon ) . '"' : '' )
									. ( ! empty( $takeout_anchor_text ) ? ' title="' . esc_attr( $takeout_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $takeout_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$takeout_scheme = takeout_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $takeout_scheme ) && ! takeout_is_inherit( $takeout_scheme ) ) {
			echo ' scheme_' . esc_attr( $takeout_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( takeout_get_theme_option( 'front_page_title_paddings' ) );
		if ( takeout_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$takeout_css      = '';
		$takeout_bg_image = takeout_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $takeout_bg_image ) ) {
			$takeout_css .= 'background-image: url(' . esc_url( takeout_get_attachment_url( $takeout_bg_image ) ) . ');';
		}
		if ( ! empty( $takeout_css ) ) {
			echo ' style="' . esc_attr( $takeout_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$takeout_anchor_icon = takeout_get_theme_option( 'front_page_title_anchor_icon' );
		$takeout_anchor_text = takeout_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $takeout_anchor_icon ) || ! empty( $takeout_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $takeout_anchor_icon ) ? ' icon="' . esc_attr( $takeout_anchor_icon ) . '"' : '' )
									. ( ! empty( $takeout_anchor_text ) ? ' title="' . esc_attr( $takeout_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( takeout_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' takeout-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$takeout_css      = '';
			$takeout_bg_mask  = takeout_get_theme_option( 'front_page_title_bg_mask' );
			$takeout_bg_color_type = takeout_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $takeout_bg_color_type ) {
				$takeout_bg_color = takeout_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $takeout_bg_color_type ) {
				$takeout_bg_color = takeout_get_scheme_color( 'bg_color', $takeout_scheme );
			} else {
				$takeout_bg_color = '';
			}
			if ( ! empty( $takeout_bg_color ) && $takeout_bg_mask > 0 ) {
				$takeout_css .= 'background-color: ' . esc_attr(
					1 == $takeout_bg_mask ? $takeout_bg_color : takeout_hex2rgba( $takeout_bg_color, $takeout_bg_mask )
				) . ';';
			}
			if ( ! empty( $takeout_css ) ) {
				echo ' style="' . esc_attr( $takeout_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$takeout_caption = takeout_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $takeout_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $takeout_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $takeout_caption, 'takeout_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$takeout_description = takeout_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $takeout_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $takeout_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $takeout_description ), 'takeout_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( takeout_get_theme_option( 'front_page_title_button1_link' ) != '' || takeout_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						takeout_show_layout( takeout_customizer_partial_refresh_front_page_title_button1_link() );
						takeout_show_layout( takeout_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
