<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package TAKEOUT
 * @since TAKEOUT 1.0
 */

							do_action( 'takeout_action_page_content_end_text' );
							
							// Widgets area below the content
							takeout_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'takeout_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'takeout_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'takeout_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'takeout_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$takeout_body_style = takeout_get_theme_option( 'body_style' );
					$takeout_widgets_name = takeout_get_theme_option( 'widgets_below_page', 'hide' );
					$takeout_show_widgets = ! takeout_is_off( $takeout_widgets_name ) && is_active_sidebar( $takeout_widgets_name );
					$takeout_show_related = takeout_is_single() && takeout_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $takeout_show_widgets || $takeout_show_related ) {
						if ( 'fullscreen' != $takeout_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $takeout_show_related ) {
							do_action( 'takeout_action_related_posts' );
						}

						// Widgets area below page content
						if ( $takeout_show_widgets ) {
							takeout_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $takeout_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'takeout_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'takeout_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! takeout_is_singular( 'post' ) && ! takeout_is_singular( 'attachment' ) ) || ! in_array ( takeout_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="takeout_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'takeout_action_before_footer' );

				// Footer
				$takeout_footer_type = takeout_get_theme_option( 'footer_type' );
				if ( 'custom' == $takeout_footer_type && ! takeout_is_layouts_available() ) {
					$takeout_footer_type = 'default';
				}
				get_template_part( apply_filters( 'takeout_filter_get_template_part', "templates/footer-" . sanitize_file_name( $takeout_footer_type ) ) );

				do_action( 'takeout_action_after_footer' );

			}
			?>

			<?php do_action( 'takeout_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'takeout_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'takeout_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>