<?php
/**
 * File: CdnEngine.php
 *
 * @package W3TC
 */

namespace W3TC;

/**
 * Class: CdnEngine
 *
 * phpcs:disable WordPress.PHP.DiscouragedPHPFunctions.serialize_serialize
 */
class CdnEngine {
	/**
	 * Returns CdnEngine_Base instance.
	 *
	 * @param string $engine CDN engine.
	 * @param array  $config Configuration.
	 *
	 * @return CdnEngine_Base
	 */
	public static function instance( $engine, array $config = array() ) {
		static $instances = array();
		$instance_key     = sprintf( '%s_%s', $engine, md5( serialize( $config ) ) );

		if ( ! isset( $instances[ $instance_key ] ) ) {
			switch ( $engine ) {
				case 'akamai':
					$instances[ $instance_key ] = new CdnEngine_Mirror_Akamai( $config );
					break;

				case 'att':
					$instances[ $instance_key ] = new CdnEngine_Mirror_Att( $config );
					break;

				case 'azure':
					$instances[ $instance_key ] = new CdnEngine_Azure( $config );
					break;

				case 'azuremi':
					$instances[ $instance_key ] = new CdnEngine_Azure_MI( $config );
					break;

				case 'bunnycdn':
					$instances[ $instance_key ] = new CdnEngine_Mirror_BunnyCdn( $config );
					break;

				case 'cf':
					$instances[ $instance_key ] = new CdnEngine_CloudFront( $config );
					break;

				case 'cf2':
					$instances[ $instance_key ] = new CdnEngine_Mirror_CloudFront( $config );
					break;

				case 'cotendo':
					$instances[ $instance_key ] = new CdnEngine_Mirror_Cotendo( $config );
					break;

				case 'edgecast':
					$instances[ $instance_key ] = new CdnEngine_Mirror_Edgecast( $config );
					break;

				case 'ftp':
					$instances[ $instance_key ] = new CdnEngine_Ftp( $config );
					break;

				case 'google_drive':
					$instances[ $instance_key ] = new CdnEngine_GoogleDrive( $config );
					break;

				case 'mirror':
					$instances[ $instance_key ] = new CdnEngine_Mirror( $config );
					break;

				case 'rackspace_cdn':
					$instances[ $instance_key ] = new CdnEngine_Mirror_RackSpaceCdn( $config );
					break;

				case 'rscf':
					$instances[ $instance_key ] = new CdnEngine_RackSpaceCloudFiles( $config );
					break;

				case 's3':
					$instances[ $instance_key ] = new CdnEngine_S3( $config );
					break;

				case 's3_compatible':
					$instances[ $instance_key ] = new CdnEngine_S3_Compatible( $config );
					break;

				default:
					empty( $engine ) || trigger_error( 'Incorrect CDN engine', E_USER_WARNING ); // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_trigger_error

					$instances[ $instance_key ] = new CdnEngine_Base();
					break;
			}
		}

		return $instances[ $instance_key ];
	}
}
