<?php
/*
Plugin Name: Ecomart Load Calculator
Description: A custom load calculator for recommending renewable energy products based on user selections.
Version: 1.0
Author: Grok
*/

// Enqueue scripts and styles
function ecomart_load_calculator_enqueue() {
    wp_enqueue_script('jquery');
    wp_enqueue_script('ecomart-calculator-js', plugin_dir_url(__FILE__) . 'calculator.js', array('jquery'), '1.0', true);
    wp_enqueue_style('ecomart-calculator-css', plugin_dir_url(__FILE__) . 'calculator.css');
}
add_action('wp_enqueue_scripts', 'ecomart_load_calculator_enqueue');

// Shortcode for the calculator
function ecomart_load_calculator_shortcode() {
    ob_start();
    ?>
    <div id="load-calculator">
        <h2>Load Calculator</h2>
        <p>Select your appliances, quantities, and desired backup time to get product recommendations.</p>
        
        <form id="calculator-form">
            <div id="appliances">
                <div class="appliance-row">
                    <select name="appliance[]" class="appliance-select">
                        <option value="">Select Appliance</option>
                        <!-- Predefined appliances with wattage -->
                        <option value="fan|60">Ceiling Fan (60W)</option>
                        <option value="light|10">LED Light (10W)</option>
                        <option value="tv|100">TV (100W)</option>
                        <option value="fridge|150">Refrigerator (150W)</option>
                        <option value="ac|1000">Air Conditioner (1000W)</option>
                        <option value="laptop|50">Laptop (50W)</option>
                        <!-- Add more as needed -->
                    </select>
                    <input type="number" name="quantity[]" class="quantity" min="1" value="1" placeholder="Quantity">
                    <button type="button" class="remove-row">Remove</button>
                </div>
            </div>
            <button type="button" id="add-appliance">Add Another Appliance</button>
            
            <div>
                <label for="backup-time">Backup Time (hours):</label>
                <select id="backup-time" name="backup-time">
                    <option value="6">6 hours</option>
                    <option value="12">12 hours</option>
                    <option value="24">24 hours</option>
                    <!-- Add more options as needed -->
                </select>
            </div>
            
            <button type="button" id="calculate">Calculate & Recommend</button>
        </form>
        
        <div id="results" style="display:none;">
            <h3>Calculation Results</h3>
            <p>Total Load: <span id="total-load"></span> Watts</p>
            <p>Required Energy: <span id="required-energy"></span> Wh</p>
            <p>Recommended Inverter Size: <span id="rec-inverter"></span> VA</p>
            <p>Recommended Battery Capacity: <span id="rec-battery"></span> Ah (at 12V)</p>
            
            <h3>Recommended Products</h3>
            <div id="product-recommendations"></div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('load_calculator', 'ecomart_load_calculator_shortcode');

// AJAX handler for product recommendations
add_action('wp_ajax_get_recommendations', 'ecomart_get_recommendations');
add_action('wp_ajax_nopriv_get_recommendations', 'ecomart_get_recommendations');

function ecomart_get_recommendations() {
    $total_load = intval($_POST['total_load']);
    $required_energy = intval($_POST['required_energy']);
    $rec_inverter = intval($_POST['rec_inverter']);
    $rec_battery = intval($_POST['rec_battery']);

    // Assumptions: Products have custom meta fields
    // - For inverters: 'inverter_va' (numeric VA rating)
    // - For batteries: 'battery_ah' (numeric Ah at 12V)
    // Adjust meta keys as per your setup

    $recommendations = array();

    // Recommend inverters >= rec_inverter VA
    $inverter_args = array(
        'post_type' => 'product',
        'posts_per_page' => 3, // Limit to top 3
        'meta_query' => array(
            array(
                'key' => 'inverter_va',
                'value' => $rec_inverter,
                'compare' => '>=',
                'type' => 'NUMERIC'
            )
        ),
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => 'inverters' // Adjust category slug
            )
        )
    );
    $inverters = wc_get_products($inverter_args);
    if (!empty($inverters)) {
        $recommendations['inverters'] = array_map(function($product) {
            return array(
                'name' => $product->get_name(),
                'link' => get_permalink($product->get_id()),
                'price' => $product->get_price_html()
            );
        }, $inverters);
    }

    // Recommend batteries >= rec_battery Ah
    $battery_args = array(
        'post_type' => 'product',
        'posts_per_page' => 3,
        'meta_query' => array(
            array(
                'key' => 'battery_ah',
                'value' => $rec_battery,
                'compare' => '>=',
                'type' => 'NUMERIC'
            )
        ),
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => 'batteries' // Adjust category slug
            )
        )
    );
    $batteries = wc_get_products($battery_args);
    if (!empty($batteries)) {
        $recommendations['batteries'] = array_map(function($product) {
            return array(
                'name' => $product->get_name(),
                'link' => get_permalink($product->get_id()),
                'price' => $product->get_price_html()
            );
        }, $batteries);
    }

    // You can add more categories like solar panels, etc.

    wp_send_json_success($recommendations);
}