<?php

/**
 * Handles the Whatsapp Chat Support functionality.
 *
 * @package    Whatsapp chat support
 * @version    1.0
 * @author     ThemeAtelier
 * @website    https://themeatelier.net/
 */

namespace ThemeAtelier\ChatWhatsappPro\Frontend\Shortcode;

use ThemeAtelier\ChatWhatsappPro\Frontend\CustomButtonsTemplates;

/**
 * Class CustomShortcode
 *
 * This class handles the custom shortcode functionality for WhatsApp chat buttons.
 *
 * @since 1.0.0
 */
class CustomShortcode {


	/**
	 * Handles the custom buttons shortcode rendering.
	 *
	 * This function is responsible for rendering custom WhatsApp buttons via shortcodes.
	 *
	 * @since 1.0.0
	 *
	 * @return string The HTML output for the custom WhatsApp buttons.
	 */
	public function ctw_custom_buttons_shortcode( $atts ) {
		// Function implementation goes here.
		$atts = shortcode_atts(
			array(
				'style'       => '1',
				'photo'       => CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/user.webp',
				'name'        => esc_html__( 'Robert', 'chat-whatsapp-pro' ),
				'designation' => esc_html__( 'Sales Support', 'chat-whatsapp-pro' ),
				'label'       => esc_html__( 'How can I help you?', 'chat-whatsapp-pro' ),
				'online'      => esc_html__( 'I\'m avaiable', 'chat-whatsapp-pro' ),
				'offline'     => esc_html__( 'I\'m offline', 'chat-whatsapp-pro' ),
				'number'      => esc_html__( '+8801813381520', 'chat-whatsapp-pro' ),
				'visibility'  => 'wHelp-show-everywhere',
				'sizes'       => 'wHelp-btn-md',
				'rounded'     => 'wHelp-btn-rounded',
				'timezone'    => '',
				'sunday'      => esc_html__( '00:00-23:59', 'chat-whatsapp-pro' ),
				'monday'      => esc_html__( '00:00-23:59', 'chat-whatsapp-pro' ),
				'tuesday'     => esc_html__( '00:00-23:59', 'chat-whatsapp-pro' ),
				'wednesday'   => esc_html__( '00:00-23:59', 'chat-whatsapp-pro' ),
				'thursday'    => esc_html__( '00:00-23:59', 'chat-whatsapp-pro' ),
				'friday'      => esc_html__( '00:00-23:59', 'chat-whatsapp-pro' ),
				'saturday'    => esc_html__( '00:00-23:59', 'chat-whatsapp-pro' ),
			),
			$atts
		);

		ob_start();

		$button_obj = new CustomButtonsTemplates( $atts );

		if ( ! empty( $atts['style'] ) ) {

			// Style Switch
			switch ( $atts['style'] ) {
				case '1':
					$button_obj->ctw_button_s1();
					break;
				case '2':
					$button_obj->ctw_button_s2();
					break;
				default:
					$button_obj->ctw_button_s1();
					break;
			}
		}

		return ob_get_clean();
	}
}
